/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.util.Log;
import com.gprinter.command.EscCommand;
import com.gprinter.utils.BMPConverterUtil;
import com.gprinter.utils.BitmapUtils;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.ZLibUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class LabelCommand {
    private static final String DEBUG_TAG = "LabelCommand";
    Vector<Byte> Command = null;

    public LabelCommand() {
        this.Command = new Vector();
    }

    public LabelCommand(int width, int height, int gap) {
        this.Command = new Vector(4096, 1024);
        this.addSize(width, height);
        this.addGap(gap);
    }

    public void clrCommand() {
        this.Command.clear();
    }

    private void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB18030");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void addGap(int gap) {
        String str = "GAP " + gap + " mm," + 0 + " mm\r\n";
        this.addStrToCommand(str);
    }

    public void addBline(int bline) {
        String str = "BLINE " + bline + " mm," + 0 + " mm\r\n";
        this.addStrToCommand(str);
    }

    public void addSize(int width, int height) {
        String str = "SIZE " + width + " mm," + height + " mm\r\n";
        this.addStrToCommand(str);
    }

    public void addCashdrwer(FOOT m, int t1, int t2) {
        String str = "CASHDRAWER " + m.getValue() + "," + t1 + "," + t2 + "\r\n";
        this.addStrToCommand(str);
    }

    public void addOffset(int offset) {
        String str = "OFFSET " + offset + " mm\r\n";
        this.addStrToCommand(str);
    }

    public void addSpeed(SPEED speed) {
        String str = "SPEED " + speed.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addDensity(DENSITY density) {
        String str = "DENSITY " + density.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addDirection(DIRECTION direction, MIRROR mirror) {
        String str = "DIRECTION " + direction.getValue() + ',' + mirror.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addReference(int x, int y) {
        String str = "REFERENCE " + x + "," + y + "\r\n";
        this.addStrToCommand(str);
    }

    public void addShift(int shift) {
        String str = "SHIFT " + shift + "\r\n";
        this.addStrToCommand(str);
    }

    public void addCls() {
        String str = "CLS\r\n";
        this.addStrToCommand(str);
    }

    public void addFeed(int dot) {
        String str = "FEED " + dot + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBackFeed(int dot) {
        String str = "BACKFEED " + dot + "\r\n";
        this.addStrToCommand(str);
    }

    public void addFormFeed() {
        String str = "FORMFEED\r\n";
        this.addStrToCommand(str);
    }

    public void addHome() {
        String str = "HOME\r\n";
        this.addStrToCommand(str);
    }

    public void addPrint(int m, int n) {
        String str = "PRINT " + m + "," + n + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrint(int m) {
        String str = "PRINT " + m + "\r\n";
        this.addStrToCommand(str);
    }

    public void addCodePage(CODEPAGE page) {
        String str = "CODEPAGE " + page.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addSound(int level, int interval) {
        String str = "SOUND " + level + "," + interval + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLimitFeed(int n) {
        String str = "LIMITFEED " + n + "\r\n";
        this.addStrToCommand(str);
    }

    public void addSelfTest() {
        String str = "SELFTEST\r\n";
        this.addStrToCommand(str);
    }

    public void addBar(int x, int y, int width, int height) {
        String str = "BAR " + x + "," + y + "," + width + "," + height + "\r\n";
        this.addStrToCommand(str);
    }

    public void drawDashLine(int x1, int y1, int x2, int y2, int lineWidth, int solid, int blank) {
        block15: {
            int lineY;
            int LineRemainder;
            int lineNum;
            if (y1 == y2) {
                int lineX;
                lineNum = (x2 - x1) / (solid + blank);
                LineRemainder = (x2 - x1) % solid + blank;
                if (LineRemainder == 0) {
                    lineX = x1;
                    for (int i = 0; i < lineNum; ++i) {
                        String str = "BAR " + lineX + "," + y1 + "," + solid + "," + lineWidth + "\r\n";
                        this.addStrToCommand(str);
                        lineX = lineX + solid + blank;
                    }
                } else if (LineRemainder > solid) {
                    lineX = x1;
                    for (int i = 0; i < lineNum + 1; ++i) {
                        String str = "BAR " + lineX + "," + y1 + "," + solid + "," + lineWidth + "\r\n";
                        this.addStrToCommand(str);
                        lineX = lineX + solid + blank;
                    }
                } else {
                    lineX = x1;
                    String str = "";
                    for (int i = 0; i < lineNum + 1; ++i) {
                        str = i < lineNum ? "BAR " + lineX + "," + y1 + "," + solid + "," + lineWidth + "\r\n" : "BAR " + lineX + "," + y1 + "," + LineRemainder + "," + lineWidth + "\r\n";
                        this.addStrToCommand(str);
                        lineX = lineX + solid + blank;
                    }
                }
            }
            if (x1 != x2) break block15;
            lineNum = (y2 - y1) / (solid + blank);
            LineRemainder = (y2 - y1) % solid + blank;
            if (LineRemainder == 0) {
                lineY = y1;
                for (int i = 0; i < lineNum; ++i) {
                    String str = "BAR " + x1 + "," + lineY + "," + lineWidth + "," + solid + "\r\n";
                    this.addStrToCommand(str);
                    lineY = lineY + solid + blank;
                }
            } else if (LineRemainder > solid) {
                lineY = y1;
                for (int i = 0; i < lineNum + 1; ++i) {
                    String str = "BAR " + x1 + "," + lineY + "," + lineWidth + "," + solid + "\r\n";
                    this.addStrToCommand(str);
                    lineY = lineY + solid + blank;
                }
            } else {
                lineY = y1;
                String str = "";
                for (int i = 0; i < lineNum + 1; ++i) {
                    str = i < lineNum ? "BAR " + x1 + "," + lineY + "," + lineWidth + "," + solid + "\r\n" : "BAR " + x1 + "," + lineY + "," + lineWidth + "," + LineRemainder + "\r\n";
                    this.addStrToCommand(str);
                    lineY = lineY + solid + blank;
                }
            }
        }
    }

    public void addText(int x, int y, FONTTYPE font, ROTATION rotation, FONTMUL Xscal, FONTMUL Yscal, String text) {
        String str = "TEXT " + x + "," + y + ",\"" + font.getValue() + "\"," + rotation.getValue() + "," + Xscal.getValue() + "," + Yscal.getValue() + ",\"" + text + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addUnicodeText(int x, int y, FONTTYPE font, ROTATION rotation, FONTMUL Xscal, FONTMUL Yscal, String text, String textType) {
        String str = "TEXT " + x + "," + y + ",\"" + font.getValue() + "\"," + rotation.getValue() + "," + Xscal.getValue() + "," + Yscal.getValue() + ",\"" + text + "\"\r\n";
        this.addStrToUnicodeCommand(str, textType);
    }

    public void addBlock(int x, int y, int width, int height, FONTTYPE font, ROTATION rotation, FONTMUL Xscal, FONTMUL Yscal, String text) {
        String str = "BLOCK " + x + "," + y + "," + width + "," + height + ",\"" + font.getValue() + "\"," + rotation.getValue() + "," + Xscal.getValue() + "," + Yscal.getValue() + ",\"" + text + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addBlock(int x, int y, int width, int height, FONTTYPE font, ROTATION rotation, FONTMUL Xscal, FONTMUL Yscal, int space, int align, String text) {
        String str = "BLOCK " + x + "," + y + "," + width + "," + height + ",\"" + font.getValue() + "\"," + rotation.getValue() + "," + space + "," + align + "," + Xscal.getValue() + "," + Yscal.getValue() + ",\"" + text + "\"\r\n";
        this.addStrToCommand(str);
    }

    private void addStrToUnicodeCommand(String str, String textType) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes(textType);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void add1DBarcode(int x, int y, BARCODETYPE type, int height, READABEL readable, ROTATION rotation, String content) {
        int narrow = 2;
        int width = 2;
        String str = "BARCODE " + x + "," + y + ",\"" + type.getValue() + "\"," + height + "," + readable.getValue() + "," + rotation.getValue() + "," + narrow + "," + width + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void add1DBarcode(int x, int y, BARCODETYPE type, int height, READABEL readable, ROTATION rotation, int narrow, int width, String content) {
        String str = "BARCODE " + x + "," + y + ",\"" + type.getValue() + "\"," + height + "," + readable.getValue() + "," + rotation.getValue() + "," + narrow + "," + width + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addBox(int x, int y, int xend, int yend, int thickness) {
        String str = "BOX " + x + "," + y + "," + xend + "," + yend + "," + thickness + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBitmap(int x, int y, BITMAP_MODE mode, int nWidth, Bitmap b) {
        if (b != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = b.getHeight() * width / b.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + b.getWidth()));
            Bitmap grayBitmap = GpUtils.toGrayscale(b);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            String str = "BITMAP " + x + "," + y + "," + (width /= 8) + "," + height + "," + mode.getValue() + ",";
            this.addStrToCommand(str);
            byte[] codecontent = GpUtils.pixToLabelCmd(src);
            for (int k = 0; k < codecontent.length; ++k) {
                this.Command.add(codecontent[k]);
            }
            Log.d((String)DEBUG_TAG, (String)("codecontent" + codecontent));
        }
    }

    public void drawImage(int startX, int startY, Bitmap bitmap, int width, int height) {
        width = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        height = bitmap.getHeight();
        byte[] imgData = this.imageProcess(bitmap);
        for (int i = 0; i < imgData.length; ++i) {
            imgData[i] = ~imgData[i];
        }
        byte[] data = new byte[]{};
        try {
            data = String.format("BITMAP %d,%d,%d,%d,1,", startX, startY, width, height).getBytes("GB18030");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.addUserCommand(data);
        this.addUserCommand(imgData);
    }

    private byte[] imageProcess(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int index = 0;
        try {
            int i;
            int bytesWidth = width % 8 == 0 ? width / 8 : width / 8 + 1;
            int byteSize = height * bytesWidth;
            byte[] bArr = new byte[byteSize];
            for (i = 0; i < byteSize; ++i) {
                bArr[i] = 0;
            }
            for (int j = 0; j < height; ++j) {
                int[] tempArray = new int[width];
                bitmap.getPixels(tempArray, 0, width, 0, j, width, 1);
                int indexLine = 0;
                for (i = 0; i < width; ++i) {
                    int pixel = tempArray[i];
                    if (++indexLine > 8) {
                        indexLine = 1;
                        ++index;
                    }
                    if (pixel == -1) continue;
                    int temp = 1 << 8 - indexLine;
                    if ((Color.red((int)pixel) + Color.green((int)pixel) + Color.blue((int)pixel)) / 3 >= 128) continue;
                    bArr[index] = (byte)(bArr[index] | temp);
                }
                index = bytesWidth * (j + 1);
            }
            return bArr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addBitmapByMethod(int x, int y, BITMAP_MODE mode, int nWidth, Bitmap b) {
        if (b != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = b.getHeight() * width / b.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + b.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(b, width, height);
            Bitmap grayBitmap = GpUtils.filter(rszBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(grayBitmap);
            height = src.length / width;
            String str = "BITMAP " + x + "," + y + "," + (width /= 8) + "," + height + "," + mode.getValue() + ",";
            this.addStrToCommand(str);
            byte[] codecontent = GpUtils.pixToLabelCmd(src);
            for (int k = 0; k < codecontent.length; ++k) {
                this.Command.add(codecontent[k]);
            }
            Log.d((String)DEBUG_TAG, (String)("codecontent" + codecontent));
        }
    }

    public void addBitmap(int x, int y, int nWidth, Bitmap bmp) {
        if (bmp != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bmp.getHeight() * width / bmp.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + bmp.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(bmp, width, height);
            byte[] bytes = GpUtils.printTscDraw(x, y, BITMAP_MODE.OVERWRITE, rszBitmap);
            for (int i = 0; i < bytes.length; ++i) {
                this.Command.add(bytes[i]);
            }
            this.addStrToCommand("\r\n");
        }
    }

    public void drawImage(int x, int y, int nwidth, Bitmap nbitmap) {
        if (nbitmap != null) {
            int hh;
            int width = (nwidth + 7) / 8 * 8;
            int height = nbitmap.getHeight() * width / nbitmap.getWidth();
            Bitmap bitmap = GpUtils.resizeImage(nbitmap, width, height);
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            int byteCountW = (w + 7) / 8;
            String str = "BITMAP " + x + "," + y + "," + byteCountW + "," + h + "," + 0 + ",";
            this.addStrToCommand(str);
            int[] bmpData = new int[w * h];
            bitmap.copyPixelsToBuffer((Buffer)IntBuffer.wrap(bmpData));
            for (int y0 = 0; y0 < h; y0 += hh) {
                hh = h - y0;
                if (hh > 128) {
                    hh = 128;
                }
                byte[] outData = new byte[byteCountW * hh];
                for (int k = y0; k < y0 + hh; ++k) {
                    for (int xx = 0; xx < w; ++xx) {
                        int c = bmpData[k * w + xx];
                        int r = c >> 16 & 0xFF;
                        int g = c >> 8 & 0xFF;
                        int b = c >> 0 & 0xFF;
                        int gray = (r * 30 + g * 59 + b * 11 + 50) / 100;
                        if (gray <= 128) continue;
                        int tmp182_181 = byteCountW * (k - y0) + xx / 8;
                        outData[tmp182_181] = (byte)(outData[tmp182_181] | 128 >> xx % 8);
                    }
                }
                for (int i = 0; i < outData.length; ++i) {
                    this.Command.add(outData[i]);
                }
            }
        }
    }

    public void drawImage2(int x, int y, int mWidth, Bitmap mBitmap) {
        int i;
        int srcWidth = (mWidth + 7) / 8 * 8;
        int srcHeight = mBitmap.getHeight() * srcWidth / mBitmap.getWidth();
        Bitmap bitmap = GpUtils.resizeImage(mBitmap, srcWidth, srcHeight);
        String bitmapCmd = "BITMAP " + x + "," + y + "," + srcWidth / 8 + "," + srcHeight + ",0,";
        this.addStrToCommand(bitmapCmd);
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, false);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (i = 0; i < data.length; i += srcWidth) {
                int n = i + srcWidth - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        for (i = 0; i < data.length; ++i) {
            this.Command.add(data[i]);
        }
        this.addUserCommand("\r\n");
    }

    public void drawXmlImage(int x, int y, int mWidth, Bitmap nbitmap) {
        int i;
        int srcWidth = (mWidth + 7) / 8 * 8;
        int srcHeight = nbitmap.getHeight() * srcWidth / nbitmap.getWidth();
        Bitmap bitmap = GpUtils.resizeImage(nbitmap, srcWidth, srcHeight);
        String bitmapCmd = "BITMAP " + x + "," + y + "," + srcWidth / 8 + "," + srcHeight + ",0,";
        this.addStrToCommand(bitmapCmd);
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, false);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (i = 0; i < data.length; i += srcWidth) {
                int n = i + srcWidth - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        for (i = 0; i < data.length; ++i) {
            this.Command.add(data[i]);
        }
    }

    public void drawJPGImage(int x, int y, int nwidth, Bitmap nbitmap) {
        if (nbitmap != null) {
            int hh;
            int width = (nwidth + 7) / 8 * 8;
            int height = nbitmap.getHeight() * width / nbitmap.getWidth();
            Bitmap bitmap = BitmapUtils.threshold(GpUtils.resizeImage(nbitmap, width, height), true);
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            int byteCountW = (w + 7) / 8;
            String str = "BITMAP " + x + "," + y + "," + byteCountW + "," + h + "," + 0 + ",";
            this.addStrToCommand(str);
            int[] bmpData = new int[w * h];
            bitmap.copyPixelsToBuffer((Buffer)IntBuffer.wrap(bmpData));
            for (int y0 = 0; y0 < h; y0 += hh) {
                hh = h - y0;
                if (hh > 128) {
                    hh = 128;
                }
                byte[] outData = new byte[byteCountW * hh];
                for (int k = y0; k < y0 + hh; ++k) {
                    for (int xx = 0; xx < w; ++xx) {
                        int c = bmpData[k * w + xx];
                        int r = c >> 16 & 0xFF;
                        int g = c >> 8 & 0xFF;
                        int b = c >> 0 & 0xFF;
                        int gray = (r * 30 + g * 59 + b * 11 + 50) / 100;
                        if (gray <= 128) continue;
                        int tmp182_181 = byteCountW * (k - y0) + xx / 8;
                        outData[tmp182_181] = (byte)(outData[tmp182_181] | 128 >> xx % 8);
                    }
                }
                for (int i = 0; i < outData.length; ++i) {
                    this.Command.add(outData[i]);
                }
            }
        }
    }

    public void drawJPGImage2(int nwidth, Bitmap nbitmap) throws UnsupportedEncodingException {
        if (nbitmap != null) {
            int width = (nwidth + 7) / 8 * 8;
            int height = nbitmap.getHeight() * width / nbitmap.getWidth();
            Bitmap bitmap = BMPConverterUtil.floydSteinberg(GpUtils.resizeImage(nbitmap, width, height), 0);
            byte[] data = PDFUtils.drawTscPDF(bitmap);
            for (int i = 0; i < data.length; ++i) {
                this.Command.add(data[i]);
            }
        }
    }

    public void getDitheredImage(int x, int y, int width, int height, Bitmap bitmap) {
        int j;
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        int w = (scaledBitmap.getWidth() + 7) / 8;
        int h = w * scaledBitmap.getHeight();
        String str = "BITMAP " + x + "," + y + "," + w + "," + h + "," + 0 + ",";
        this.addUserCommand(str);
        int[] ww = this.getRow(scaledBitmap, 0);
        int[] hh = this.getRow(scaledBitmap, 1);
        int var6 = width / 8 + (width % 8 == 0 ? 0 : 1);
        int var7 = 8 - width % 8;
        if (var7 == 8) {
            var7 = 0;
        }
        byte[] var8 = new byte[var6];
        int var9 = 0;
        for (j = 0; j < width; ++j) {
            ww[j] = LabelCommand.convertByteToGrayscale(ww[j]);
        }
        for (j = 0; j < height; ++j) {
            int var11;
            for (var11 = 0; var11 < var8.length; ++var11) {
                var8[var11] = 0;
            }
            var11 = 0;
            for (int i = 0; i < width; ++i) {
                if (i % 8 == 0) {
                    var9 = -128;
                }
                int var13 = ww[i];
                var11 = i / 8;
                int var14 = var13 >= 128 ? -1 : 0;
                var8[var11] = (byte)(var8[var11] | var9 & var14);
                int var15 = var13 - (var14 & 0xFF);
                if (i < width - 1) {
                    int n = i + 1;
                    ww[n] = ww[n] + 7 * var15 / 16;
                }
                if (i > 0 && j < height - 1) {
                    int n = i - 1;
                    hh[n] = hh[n] + 3 * var15 / 16;
                }
                if (j < height - 1) {
                    if (i == 0) {
                        hh[i] = LabelCommand.convertByteToGrayscale(hh[i]);
                    }
                    int n = i;
                    hh[n] = hh[n] + 5 * var15 / 16;
                }
                if (j < height - 1 && i < width - 1) {
                    hh[i + 1] = LabelCommand.convertByteToGrayscale(hh[i + 1]);
                    int n = i + 1;
                    hh[n] = hh[n] + 1 * var15 / 16;
                }
                var9 = (byte)((var9 & 0xFF) >>> 1);
            }
            var8[var11] = (byte)(var8[var11] | 255 >>> 8 - var7);
            this.addUserCommand(var8);
            ww = hh;
            hh = this.getRow(scaledBitmap, j + 2);
        }
    }

    public int[] getRow(Bitmap bitmap, int var1) {
        if (var1 >= bitmap.getHeight()) {
            return null;
        }
        int var2 = bitmap.getWidth();
        int[] var3 = new int[var2];
        bitmap.getPixels(var3, 0, var2, 0, var1, var2, 1);
        return var3;
    }

    private static int convertByteToGrayscale(int var0) {
        int var1 = (var0 & 0xFF0000) >>> 16;
        int var2 = (var0 & 0xFF00) >>> 8;
        int var3 = var0 & 0xFF;
        int var4 = (var1 * 30 + var2 * 59 + var3 * 11) / 100;
        if (var4 > 255) {
            var4 = 255;
        } else if (var4 < 0) {
            var4 = 0;
        }
        return var4;
    }

    public void putbmp(String imageName, int x, int y) {
        if (!imageName.endsWith(".BMP")) {
            imageName = imageName + ".BMP";
        }
        String putbmpCMD = "PUTBMP " + x + "," + y + ",\"" + imageName + "\"\r\n";
        this.addStrToCommand(putbmpCMD);
    }

    public void downFlashBitmap(byte[] data, int nWidth, String imageName) {
        String downloadCmd = "DOWNLOAD F,\"" + imageName + "\"," + data.length + ",";
        byte[] download_head = new byte[]{};
        try {
            download_head = downloadCmd.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.addUserCommand(download_head);
        for (int i = 0; i < data.length; ++i) {
            this.Command.add(data[i]);
        }
        this.addUserCommand("\r\n");
    }

    public void downloadBMP(Bitmap mbitmap, String imageName, int nWidth) {
        if (mbitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = mbitmap.getHeight() * width / mbitmap.getWidth();
            Bitmap scaledBitmap = BitmapUtils.resizeImageAndRotation(mbitmap, width, height);
            int w = scaledBitmap.getWidth();
            int h = scaledBitmap.getHeight();
            int[] pixels = new int[w * h];
            scaledBitmap.getPixels(pixels, 0, w, 0, 0, w, h);
            byte[] rgb = LabelCommand.toPrintData(scaledBitmap);
            byte[] header = this.addBMPImageHeader(62 + rgb.length);
            byte[] infos = this.addBMPImageInfosHeader(w, h, rgb.length);
            byte[] colortable = this.addBMPImageColorTable();
            byte[] buffer = new byte[62 + rgb.length];
            System.arraycopy(header, 0, buffer, 0, header.length);
            System.arraycopy(infos, 0, buffer, 14, infos.length);
            System.arraycopy(colortable, 0, buffer, 54, colortable.length);
            System.arraycopy(rgb, 0, buffer, 62, rgb.length);
            String downloadCmd = "DOWNLOAD \"" + imageName + "\"," + buffer.length + ",";
            this.addUserCommand(downloadCmd);
            this.addUserCommand(buffer);
        }
    }

    private byte[] addBMPImageHeader(int size) {
        byte[] buffer = new byte[]{66, 77, (byte)(size >> 0), (byte)(size >> 8), (byte)(size >> 16), (byte)(size >> 24), 0, 0, 0, 0, 62, 0, 0, 0};
        return buffer;
    }

    private byte[] addBMPImageInfosHeader(int w, int h, int size) {
        Log.i((String)"_DETEST_", (String)("size=" + size));
        byte[] buffer = new byte[]{40, 0, 0, 0, (byte)(w >> 0), (byte)(w >> 8), (byte)(w >> 16), (byte)(w >> 24), (byte)(h >> 0), (byte)(h >> 8), (byte)(h >> 16), (byte)(h >> 24), 1, 0, 1, 0, 0, 0, 0, 0, (byte)(size >> 0), (byte)(size >> 8), (byte)(size >> 16), (byte)(size >> 24), -61, 14, 0, 0, -61, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return buffer;
    }

    private byte[] addBMPImageColorTable() {
        byte[] buffer = new byte[]{-1, -1, -1, 0, 0, 0, 0, 0};
        return buffer;
    }

    private byte[] addBMP_RGB_888(int[] b, int w, int h) {
        int len = w * h;
        int bufflen = 0;
        byte[] tmp = new byte[3];
        int index = 0;
        int bitindex = 1;
        bufflen = w * h % 8 != 0 ? w * h / 8 + 1 : w * h / 8;
        if (bufflen % 4 != 0) {
            bufflen += bufflen % 4;
        }
        byte[] buffer = new byte[bufflen];
        for (int i = len - 1; i >= w; i -= w) {
            int start;
            int end = i;
            for (int j = start = i - w + 1; j <= end; ++j) {
                tmp[0] = (byte)(b[j] >> 0);
                tmp[1] = (byte)(b[j] >> 8);
                tmp[2] = (byte)(b[j] >> 16);
                String hex = "";
                for (int g = 0; g < tmp.length; ++g) {
                    String temp = Integer.toHexString(tmp[g] & 0xFF);
                    if (temp.length() == 1) {
                        temp = "0" + temp;
                    }
                    hex = hex + temp;
                }
                if (bitindex > 8) {
                    ++index;
                    bitindex = 1;
                }
                if (hex.equals("ffffff")) {
                    buffer[index] = (byte)(buffer[index] | 1 << 8 - bitindex);
                }
                ++bitindex;
            }
        }
        return buffer;
    }

    public static Bitmap convertToBlackWhite(Bitmap bmp) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        int[] pixels = new int[width * height];
        bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        int alpha = -16777216;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int grey = pixels[width * i + j];
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                grey = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                pixels[width * i + j] = grey = alpha | grey << 16 | grey << 8 | grey;
            }
        }
        Bitmap newBmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        newBmp.setPixels(pixels, 0, width, 0, 0, width, height);
        return newBmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBitmapByte(Bitmap bitmap) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Bitmap getBitmapFromByte(byte[] temp) {
        if (temp != null) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])temp, (int)0, (int)temp.length);
            return bitmap;
        }
        return null;
    }

    public void addZLibBitmap(int x, int y, int nWidth, Bitmap bitmap) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = GpUtils.toGrayscale(bitmap);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            width /= 8;
            byte[] codeContent = GpUtils.ZlibpixToLabelCmd(src);
            byte[] compressByte = new byte[]{};
            try {
                compressByte = ZLibUtils.zLib(codeContent);
            }
            catch (IOException var14) {
                var14.printStackTrace();
            }
            String str = "BITMAP " + x + "," + y + "," + width + "," + height + ",3," + compressByte.length + ",";
            this.addStrToCommand(str);
            for (int k = 0; k < compressByte.length; ++k) {
                this.Command.add(compressByte[k]);
            }
            Log.d((String)DEBUG_TAG, (String)("codecontent" + codeContent));
        }
    }

    public void addNewBitmap(int x, int y, int nWidth, Bitmap b, int level) {
        if (b != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = b.getHeight() * width / b.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + b.getWidth()));
            Bitmap grayBitmap = GpUtils.toGrayscale(b);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            width /= 8;
            byte[] codecontent = GpUtils.ZlibpixToLabelCmd(src);
            byte[] compressByte = new byte[]{};
            try {
                compressByte = ZLibUtils.zLib(codecontent, level);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String str = "BITMAP " + x + "," + y + "," + width + "," + height + ",3," + compressByte.length + ",";
            this.addStrToCommand(str);
            for (int k = 0; k < compressByte.length; ++k) {
                this.Command.add(compressByte[k]);
            }
            Log.d((String)DEBUG_TAG, (String)("codecontent" + codecontent));
        }
    }

    public void addNewBitmap300(int x, int y, int nWidth, Bitmap b, int level) {
        if (b != null) {
            int width = (nWidth + 11) / 12 * 12;
            int height = b.getHeight() * width / b.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + b.getWidth()));
            Bitmap grayBitmap = GpUtils.toGrayscale(b);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            width /= 12;
            byte[] codecontent = GpUtils.ZlibpixToLabelCmd(src);
            byte[] compressByte = new byte[]{};
            try {
                compressByte = ZLibUtils.zLib(codecontent, level);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String str = "BITMAP " + x + "," + y + "," + width + "," + height + ",3," + compressByte.length + ",";
            this.addStrToCommand(str);
            for (int k = 0; k < compressByte.length; ++k) {
                this.Command.add(compressByte[k]);
            }
            Log.d((String)DEBUG_TAG, (String)("codecontent" + codecontent));
        }
    }

    public void addZLibBitmap200DPI(int x, int y, int bmpWidth, Bitmap b) {
        int h;
        int w;
        Bitmap grayBitmap = GpUtils.toGrayscale(b);
        Bitmap bitmap = BitmapUtils.resizeImage(grayBitmap, w = (bmpWidth + 7) / 8 * 8, h = b.getHeight() * bmpWidth / b.getWidth());
        int width = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int height = bitmap.getHeight();
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, false);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (int x3 = 0; x3 < data.length; x3 += width) {
                int n = x3 + width - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        byte[] compressByte = new byte[]{};
        try {
            compressByte = ZLibUtils.zLib(data, 9);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String bitmapCmd = "BITMAP " + x + "," + y + "," + width + "," + height + "3," + compressByte.length + ",";
        this.addUserCommand(bitmapCmd);
    }

    public void addZLibCutBitmap200DPI(int x, int y, int nWidth, Bitmap bitmap, boolean cut) {
        int photoHeight;
        if (bitmap != null && (photoHeight = 80) > 0) {
            List<Bitmap> mList = LabelCommand.ImageCrop(bitmap, photoHeight);
            for (int i = 0; i < mList.size(); ++i) {
                int width = (nWidth + 7) / 8 * 8;
                int height = mList.get(i).getHeight() * width / mList.get(i).getWidth();
                this.addSize(nWidth / 8, height / 8);
                if (i == mList.size() - 1 & cut) {
                    this.addCutter(RESPONSE_MODE.ON);
                } else {
                    this.addCutter(RESPONSE_MODE.OFF);
                }
                this.addGap(0);
                this.addCls();
                this.addZLibBitmap200DPI(x, y, nWidth, mList.get(i));
                this.addPrint(1);
            }
        }
    }

    public void addZLibBitmap300DPI(int x, int y, int bmpWidth, Bitmap b) {
        int w = (bmpWidth + 7) / 8 * 8;
        int h = b.getHeight() * bmpWidth / b.getWidth();
        Bitmap bitmap = BitmapUtils.resizeImage(b, w, h);
        int width = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int height = bitmap.getHeight();
        byte[] data = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, false);
        int x1 = bitmap.getWidth() % 8;
        if (x1 != 0) {
            for (int x3 = 0; x3 < data.length; x3 += width) {
                int n = x3 + width - 1;
                data[n] = (byte)(data[n] | (byte)(255 >> x1));
            }
        }
        byte[] compressByte = new byte[]{};
        try {
            compressByte = ZLibUtils.zLib(data, 9);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String bitmapCmd = "BITMAP " + x + "," + y + "," + width + "," + height + "3," + compressByte.length + ",";
        this.addUserCommand(compressByte);
        this.addUserCommand(bitmapCmd);
    }

    public void addZLibCutBitmap300DPI(int x, int y, int nWidth, Bitmap bitmap, boolean cut) {
        int photoHeight;
        if (bitmap != null && (photoHeight = 120) > 0) {
            List<Bitmap> mList = LabelCommand.ImageCrop(bitmap, photoHeight);
            for (int i = 0; i < mList.size(); ++i) {
                int width = (nWidth + 11) / 12 * 12;
                int height = mList.get(i).getHeight() * width / mList.get(i).getWidth();
                this.addSize(nWidth / 12, height / 12);
                this.addGap(0);
                this.addCls();
                this.addZLibBitmap300DPI(x, y, nWidth, mList.get(i));
                this.addPrint(1);
            }
        }
    }

    public void addZLibNoTrembleBitmapheight(int x, int y, int nWidth, Bitmap bitmap) {
        int photoheight;
        if (bitmap != null && (photoheight = 100) > 0) {
            List<Bitmap> mlist = LabelCommand.ImageCrop(bitmap, photoheight);
            for (int i = 0; i < mlist.size(); ++i) {
                int width = (nWidth + 7) / 8 * 8;
                int height = mlist.get(i).getHeight() * width / mlist.get(i).getWidth();
                this.addSize(nWidth / 8, height / 8);
                this.addGap(0);
                this.addDirection(DIRECTION.FORWARD, MIRROR.NORMAL);
                this.addCls();
                this.addNewBitmap(x, y, nWidth, mlist.get(i), 9);
                this.addPrint(1);
            }
        }
    }

    public void addZLibNoTrembleBitmapheight300(int x, int y, int nWidth, Bitmap bitmap) {
        int photoheight;
        if (bitmap != null && (photoheight = 120) > 0) {
            List<Bitmap> mlist = LabelCommand.ImageCrop(bitmap, photoheight);
            for (int i = 0; i < mlist.size(); ++i) {
                int width = (nWidth + 11) / 12 * 12;
                int height = mlist.get(i).getHeight() * width / mlist.get(i).getWidth();
                this.addSize(nWidth / 12, height / 12);
                this.addGap(0);
                this.addDirection(DIRECTION.FORWARD, MIRROR.NORMAL);
                this.addCls();
                this.addNewBitmap300(x, y, nWidth, mlist.get(i), 9);
                this.addPrint(1);
            }
        }
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(LabelCommand.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = LabelCommand.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    public void addZLibNoTrembleBitmap(int x, int y, int nWidth, Bitmap bitmap) {
        if (bitmap != null) {
            byte[] data = this.getZLibData(8, nWidth, bitmap);
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            String str = "BITMAP " + x + "," + y + "," + width / 8 + "," + height + ",3," + data.length + ",";
            this.addStrToCommand(str);
            for (int k = 0; k < data.length; ++k) {
                this.Command.add(data[k]);
            }
        }
    }

    public byte[] getZLibData(int w, int nWidth, Bitmap bitmap) {
        try {
            if (bitmap != null) {
                int e = (nWidth + (w - 1)) / w * w;
                int height = bitmap.getHeight() * e / bitmap.getWidth();
                Bitmap grayBitmap = GpUtils.toGrayscale(bitmap);
                Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, e, height);
                byte[] src = GpUtils.printZlibTscDraw(rszBitmap);
                byte[] compressByte = ZLibUtils.zLib(src);
                return compressByte;
            }
        }
        catch (IOException var10) {
            var10.printStackTrace();
        }
        return null;
    }

    public void addErase(int x, int y, int xwidth, int yheight) {
        String str = "ERASE " + x + "," + y + "," + xwidth + "," + yheight + "\r\n";
        this.addStrToCommand(str);
    }

    public void addReverse(int x, int y, int xwidth, int yheight) {
        String str = "REVERSE " + x + "," + y + "," + xwidth + "," + yheight + "\r\n";
        this.addStrToCommand(str);
    }

    public void addQRCode(int x, int y, EEC level, int cellwidth, ROTATION rotation, String data) {
        String str = "QRCODE " + x + "," + y + "," + level.getValue() + "," + cellwidth + "," + 'A' + "," + rotation.getValue() + ",\"" + data + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, ROTATION rotation, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",r" + rotation.getValue() + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, int xZoom, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",x" + xZoom + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, int c, int xZoom, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",c" + c + ",x" + xZoom + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, int xZoom, int row, int col, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",x" + xZoom + "," + row + "," + col + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public void addDMATRIX(int x, int y, int width, int height, int c, int xZoom, ROTATION rotation, Shape shape, int row, int col, String content) {
        String str = "DMATRIX " + x + "," + y + "," + width + "," + height + ",c" + c + ",x" + xZoom + ",r" + rotation.getValue() + ",a" + shape.getValue() + "," + row + "," + col + ",\"" + content + "\"\r\n";
        this.addStrToCommand(str);
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void addQueryPrinterType() {
        String str = new String();
        str = "~!T\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterStatus() {
        this.Command.add((byte)27);
        this.Command.add((byte)33);
        this.Command.add((byte)63);
    }

    public void addResetPrinter() {
        this.Command.add((byte)27);
        this.Command.add((byte)33);
        this.Command.add((byte)82);
    }

    public void addQueryPrinterLife() {
        String str = "~!@\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterMemory() {
        String str = "~!A\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterFile() {
        String str = "~!F\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterCodePage() {
        String str = "~!I\r\n";
        this.addStrToCommand(str);
    }

    public void addPeel(RESPONSE_MODE enable) {
        String str = "SET PEEL " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addTear(RESPONSE_MODE mode) {
        String str = "SET TEAR " + mode.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addCutter(RESPONSE_MODE enable) {
        String str = "SET CUTTER " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addCutterBatch() {
        String str = "SET CUTTER BATCH\r\n";
        this.addStrToCommand(str);
    }

    public void addCutterPieces(short number) {
        String str = "SET CUTTER " + number + "\r\n";
        this.addStrToCommand(str);
    }

    public void addReprint(RESPONSE_MODE enable) {
        String str = "SET REPRINT " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintKey(EscCommand.ENABLE enable) {
        String str = "SET PRINTKEY " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintKey(int m) {
        String str = "SET PRINTKEY " + m + "\r\n";
        this.addStrToCommand(str);
    }

    public void addHead(ENABLE enable) {
        String str = "SET HEAD " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addRibbon(ENABLE enable) {
        String str = "SET RIBBON " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addKeyOne(ENABLE enable) {
        String str = "SET KEY1 " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addKeyTwo(ENABLE enable) {
        String str = "SET KEY2 " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPartialCutter(EscCommand.ENABLE enable) {
        String str = "SET PARTIAL_CUTTER " + enable.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterStatus(RESPONSE_MODE mode) {
        String str = "SET RESPONSE " + mode.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addCOUNTER(int number, int step) {
        String str = "SET COUNTER @" + number + " " + step + "\r\n";
        this.addStrToCommand(str);
    }

    public void addUserCommand(String command) {
        this.addStrToCommand(command);
    }

    public void addUserCommand(byte[] command) {
        for (int i = 0; i < command.length; ++i) {
            this.Command.add(command[i]);
        }
    }

    public static byte[] toPrintData(Bitmap bitmap) {
        int columnSize = (int)Math.ceil((double)bitmap.getWidth() / 8.0);
        byte[] data = new byte[columnSize * bitmap.getHeight()];
        int dataIndex = 0;
        int height = bitmap.getHeight();
        int bitmapWidth = bitmap.getWidth();
        int[] pixels = new int[bitmapWidth * height];
        bitmap.getPixels(pixels, 0, bitmapWidth, 0, 0, bitmapWidth, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < columnSize; ++x) {
                for (int dataBit = 0; dataBit < 8; ++dataBit) {
                    int lineIndex = x * 8 + dataBit;
                    if (lineIndex >= bitmapWidth) continue;
                    int pixelColor = pixels[y * bitmapWidth + lineIndex];
                    int R = Color.red((int)pixelColor);
                    data[dataIndex] = R < 200 ? (byte)(data[dataIndex] << 1 & 0xFE) : (byte)(data[dataIndex] << 1 | 1);
                }
                ++dataIndex;
            }
        }
        return data;
    }

    public static enum ENABLE {
        ON("ON"),
        OFF("OFF");

        private final String value;

        private ENABLE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RESPONSE_MODE {
        ON("ON"),
        OFF("OFF"),
        BATCH("BATCH");

        private final String value;

        private RESPONSE_MODE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BARCODETYPE {
        CODE128("128"),
        CODE128M("128M"),
        EAN128("EAN128"),
        ITF25("25"),
        ITF25C("25C"),
        CODE39("39"),
        CODE39C("39C"),
        CODE39S("39S"),
        CODE93("93"),
        EAN13("EAN13"),
        EAN13_2("EAN13+2"),
        EAN13_5("EAN13+5"),
        EAN8("EAN8"),
        EAN8_2("EAN8+2"),
        EAN8_5("EAN8+5"),
        CODABAR("CODA"),
        POST("POST"),
        UPCA("UPCA"),
        UPCA_2("UPCA+2"),
        UPCA_5("UPCA+5"),
        UPCE("UPCE13"),
        UPCE_2("UPCE13+2"),
        UPCE_5("UPCE13+5"),
        CPOST("CPOST"),
        MSI("MSI"),
        MSIC("MSIC"),
        PLESSEY("PLESSEY"),
        ITF14("ITF14"),
        EAN14("EAN14");

        private final String value;

        private BARCODETYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum EEC {
        LEVEL_L("L"),
        LEVEL_M("M"),
        LEVEL_Q("Q"),
        LEVEL_H("H");

        private final String value;

        private EEC(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Shape {
        Square("0"),
        Rectangle("1");

        private final String value;

        private Shape(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ROTATION {
        ROTATION_0(0),
        ROTATION_90(90),
        ROTATION_180(180),
        ROTATION_270(270);

        private final int value;

        private ROTATION(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FONTTYPE {
        FONT_0("0.TTF"),
        Bold("1.TTF"),
        SongTi("2.TTF"),
        Thai("4.TTF"),
        FONT_1("1"),
        FONT_2("2"),
        FONT_3("3"),
        FONT_4("4"),
        FONT_5("5"),
        FONT_6("6"),
        FONT_7("7"),
        FONT_8("8"),
        FONT_9("9"),
        FONT_10("10"),
        SIMPLIFIED_16_CHINESE("TSS16.BF2"),
        SIMPLIFIED_20_CHINESE("TSS20.BF2"),
        SIMPLIFIED_24_CHINESE("TSS24.BF2"),
        SIMPLIFIED_32_CHINESE("TSS32.BF2"),
        SIMPLIFIED_48_CHINESE("TSS48.BF2"),
        TRADITIONAL_CHINESE("TST24.BF2"),
        KOREAN("K");

        private final String value;

        private FONTTYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum FONTMUL {
        MUL_1(1),
        MUL_2(2),
        MUL_3(3),
        MUL_4(4),
        MUL_5(5),
        MUL_6(6),
        MUL_7(7),
        MUL_8(8),
        MUL_9(9),
        MUL_10(10);

        private final int value;

        private FONTMUL(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CODEPAGE {
        PC437(437),
        PC850(850),
        PC852(852),
        PC860(860),
        PC863(863),
        PC865(865),
        WPC1250(1250),
        WPC1252(1252),
        WPC1253(1253),
        WPC1254(1254);

        private final int value;

        private CODEPAGE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MIRROR {
        NORMAL(0),
        MIRROR(1);

        private final int value;

        private MIRROR(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DIRECTION {
        FORWARD(0),
        BACKWARD(1);

        private final int value;

        private DIRECTION(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DENSITY {
        DNESITY0(0),
        DNESITY1(1),
        DNESITY2(2),
        DNESITY3(3),
        DNESITY4(4),
        DNESITY5(5),
        DNESITY6(6),
        DNESITY7(7),
        DNESITY8(8),
        DNESITY9(9),
        DNESITY10(10),
        DNESITY11(11),
        DNESITY12(12),
        DNESITY13(13),
        DNESITY14(14),
        DNESITY15(15);

        private final int value;

        private DENSITY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum BITMAP_MODE {
        OVERWRITE(0),
        OR(1),
        XOR(2);

        private final int value;

        private BITMAP_MODE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum READABEL {
        DISABLE(0),
        EANBEL(1);

        private final int value;

        private READABEL(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SPEED {
        SPEED1DIV5(1.5f),
        SPEED2(2.0f),
        SPEED3(3.0f),
        SPEED4(4.0f),
        SPEED5(5.0f),
        SPEED6(6.0f),
        SPEED7(7.0f),
        SPEED8(8.0f),
        SPEED9(9.0f),
        SPEED10(10.0f),
        SPEED11(11.0f),
        SPEED12(12.0f);

        private final float value;

        private SPEED(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }
    }

    public static enum FOOT {
        F2(0),
        F5(1);

        private final int value;

        private FOOT(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

